<?php
namespace Sentiweb\Components\Mailer;

use PHPMailer\PHPMailer\PHPMailer;

/**
 * Simple Mailer implementation handling fake feature
 * @author clementturbelin
 *
 */
class Mailer extends PHPMailer {
    
    const MAILER_TYPE_FAKE = 'fake';
    const MAILER_TYPE_SMTP = 'smtp';
    
    
    protected $fakePath;
    
    public static function  getMailer($mailer_conf) {
        $mailer = new Mailer();
        $type = $mailer_conf['type'];
        
        if(!isset($mailer_conf[$type])) {
            throw new Exception("Missing mailer configuration");
        }
        
        $conf = $mailer_conf[$type];
        
        switch($type) {
            case self::MAILER_TYPE_FAKE:
                $mailer->isFake();
                $mailer->fakePath = $conf['path'];
                break;
            
            case self::MAILER_TYPE_SMTP:
                $mailer->isSmtp();
                $mailer->Host = $conf['host'];  // Specify main and backup SMTP servers
                $mailer->SMTPAuth = $conf['auth'];  // Enable SMTP authentication
                break;
                
            default:
                throw new Exception("Unknown type '$type'");
        }
        
        return $mailer;
    }
    
    public function isFake() {
        $this->Mailer = self::MAILER_TYPE_FAKE;
    }
    
    public function fakeSend($header, $body) {
        $id = date('Ymd').'_'.md5(uniqid(mt_rand(), true));
        $path = $this->fakePath.$id.'.eml';
        $txt = $header."\n".$body;
        return file_put_contents($path, $txt);
    }
    
    /**
     * Very simple mail sender
     * @param string $dest
     * @param string $subject
     * @param string $body
     * @param array $options
     */
    public function sendMail($dest, $subject, $body, $options=[]) {
        if(is_array($dest)) {
            foreach($dest as $d) {
                $this->addAddress($d);
            }
        } else {
            $this->addAddress($dest);    
        }
        $this->Subject = $subject;
        $this->Body = $body;
        $this->send();
    }
}