<?php

namespace Sentiweb\Symfony\MailerBundle;

use \Swift_Message;
			
class Mailer {

 /**
   * 
   * @var string
   */
  protected $from;
  
  /**
   * Sender
   * @var string
   */
  protected $sender;
  
  /**
   * 
   * @var string
   */
  protected $from_name;
  

  /**
   * 
   * @var \Swift_Mailer
   */
  protected $mailer;
  
  /**
   * Init mailer class and return the instance
   */
  public function __construct($swift_mailer, $conf ) {
  		$this->mailer = $swift_mailer;
  		$this->from = $conf['default_from'];
  		$this->from_name = $conf['default_from_name'];
  		if( isset($conf['sender']) ) {
  			$this->sender = $conf['sender'];
  		}
  }
  
  
  /**
   * Get the mailer and init it for a new mail
   * @return \Swift_Mailer
   */
  private function getMailer() {
  	return $this->mailer;
  }

  /**
   * Send a mail
   *
   */
  public function sendMail($to, $subject, $body) {
    $ok = true;
    $mail = $this->getMailer();

    $message = new Swift_Message();
    
    $message->setSubject($subject);
    $message->setBody($body, 'text/html');
    $message->setTo($to);
    
    $from = array();
    $from[ $this->from ] = $this->from_name;
    $message->setFrom($from);
    if($this->sender) {
    	$message->setSender($this->sender);
    	$message->setReturnPath($this->sender);
    }
  
    $mail->send($message);
    return $ok;
  }
 
}

