<?php 
namespace Sentiweb\Symfony\MailerBundle;

use \Swift_Transport;
use \Swift_Mime_Message;
use \Swift_Events_EventListener;

/**
* Fake email sending, store into directory on file system
*
* @package Swift
* @author  Fabien Potencier
*/
class FakeTransport implements Swift_Transport
{
	
	protected $path;
	
	/**
	 * Constructor.
	 */
	public function __construct($path = null)
	{
		if(!$path) {
			throw new \Exception("Fake transport require a path parameter to be set (see mailer.fake_path config)");
		}
		$this->path = $path;
	}

	public function setPath($path) {
	    $this->path= $path;
	}
	
	/**
	 * Tests if this Transport mechanism has started.
	 *
	 * @return boolean
	 */
	public function isStarted()
	{
		return true;
	}

	/**
	 * Starts this Transport mechanism.
	 */
	public function start()
	{
	}

	/**
	 * Stops this Transport mechanism.
	 */
	public function stop()
	{
	}

	/**
	 * Sends the given message.
	 *
	 * @param Swift_Mime_Message $message
	 * @param string[]           $failedRecipients An array of failures by-reference
	 *
	 * @return integer The number of sent emails
	 */
	public function send(Swift_Mime_Message $message, &$failedRecipients = null)
	{
		$uid = time().md5(uniqid());
		$fn = $this->path.'/'.$uid.'.eml';
		file_put_contents($fn, $message->toString());
		return 0;
	}

	/**
	 * Register a plugin.
	 *
	 * @param Swift_Events_EventListener $plugin
	 */
	public function registerPlugin(Swift_Events_EventListener $plugin)
	{
		// 
	}
}
