<?php
namespace Sentiweb\Symfony\MailerBundle\DependencyInjection;

use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\Config\FileLocator;

class MailerExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
    	
    	$configuration = new Configuration();
    	$config = $this->processConfiguration($configuration, $configs);
    	 
	    $loader = new YamlFileLoader(
	        $container,
	        new FileLocator(__DIR__.'/../../config')
	    );
	    $loader->load('services.yml');
	    
	    $params = $container->getParameterBag();
	    
	    $transport = $params->get('mailer_transport');
	    if($transport == 'mailer.transport.fake') {
	    	if(!isset($config['fake_path'])) {
	    		throw new \Exception("mailer config entry fake_path is required if transport use fake mailer");
	    	}
	    }
	    
	    $params->set('mailer_config', $config);
	    $params->set('mailer.fake.path', isset($config['fake_path']) ? $config['fake_path'] : null);
	    // Always set mailer fake path param
	    
    }
}