<?php

namespace Sentiweb\Symfony\MailerBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/extension.html#cookbook-bundles-extension-config-class}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritDoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('mailer');
        
        $rootNode
	        ->children()
			   ->scalarNode('default_from')->isRequired()->cannotBeEmpty()->end()
		       ->scalarNode('default_from_name')->isRequired()->cannotBeEmpty()->end()
		       ->scalarNode('sender')->end()
		       ->scalarNode('fake_path')->end()
	        ->end()
     	->end();
		    
        return $treeBuilder;
    }
}
