<?php
namespace Sentiweb\Symfony\Auth\Provider;

class IPAuth extends AbstractAuth {
    
    protected $networks;
    
    public function __construct($ips) {
        $op = array();
        if( is_string($ips) ) {
            $ips = array($ips);
        }
        foreach($ips as $n) {
            $r = $this->createOperator($n);
            $op[] = $r;
        }
        $this->networks = $op;
    }
    
    public function check() {
        $ip = $_SERVER['REMOTE_ADDR'];
        if($this->debug) {
            $this->log('IP :'.$ip);
        }
        foreach($this->networks as $net) {
            if($this->debug) {
                $this->log('check :'.$this->debug($net));
            }
            if( $this->match($net, $ip) ) {
                if($this->debug) {
                    $this->log('ip match network operator');
                }
                return true;
            }
        }
        if($this->debug) {
            $this->log('no ip match');
        }
        return false;
    }
    
    public function debug($network) {
        $type = $network['type'];
        $s = $type.' : ';
        switch($type) {
        	case 'ip':
        	    $s .= long2ip($network['value']);
        	    break;
        	    
        	case 'mask':
        	    $s .= long2ip($network['mask']).' / '.long2ip($network['network']);
        	    break;
        	     
        	case 'range':
        	   $s .= long2ip($network['from']).' - '.long2ip($network['to']);
        	   break;
        }
        return $s;
    }
    

    protected function createOperator($network) {
        $network = trim($network);
        $network = str_replace(' ', '', $network);
        
        if( filter_var($network, FILTER_VALIDATE_IP) ) {
            return array('type'=>'ip', 'value'=>ip2long($network));
        }
        
        if($network == 'all') {
            return array('type'=>'all');
        }
        
        if (strpos($network, '*') !== FALSE) {
            if (strpos($network, '/') !== FALSE) {
                $asParts = explode('/', $network);
                $network = @$asParts[0];
            }
            $nCount = substr_count($network, '*');
            $network = str_replace('*', '0', $network);
            if ($nCount == 1) {
                $network .= '/24';
            } else if ($nCount == 2) {
                $network .= '/16';
            } else if ($nCount == 3) {
                $network .= '/8';
            } else if ($nCount > 3) {
               return true;
            }
        } 
        $d = strpos($network, '-');
        if ( $d === FALSE ) {
            $ip_arr = explode('/', $network);
            if ( !preg_match("@\d*\.\d*\.\d*\.\d*@", $ip_arr[0], $matches) ){
                $ip_arr[0] .= ".0";    // Alternate form 194.1.4/24
            }
            $network_long = ip2long($ip_arr[0]);
            $x = ip2long($ip_arr[1]);
            $mask = long2ip($x) == $ip_arr[1] ? $x : (0xffffffff << (32 - $ip_arr[1]));
            
            if( $mask == long2ip('0.0.0.0') ) {
                // As zero mask valid ALL IP it should not be used
                throw new \Exception('Invalid mask : cannot be 0.0.0.0');
            }
            
            return array('type'=>'mask', 'mask'=>$mask, 'network'=>$network_long);
            
            //return ($ip_long & $mask) == ($network_long & $mask);
        } else {
            $from = trim(ip2long(substr($network, 0, $d)));
            $to = trim(ip2long(substr($network, $d+1)));
            $ip = ip2long($ip);
           return array('type'=>'range','from'=>$from, 'to'=>$to);
        }
        
    }
    
    public function match($op, $ip) {
        $ip = ip2long($ip);
        if( !$ip ) {
            return false;
        }
        switch($op['type']) {
        	case 'ip':
        	    $value = $op['value'];
        	    return $ip == $value;
        	    break;
        	    
        	case 'range':
                $from = $op['from'];
                $to = $op['to'];
                return ($ip >= $from and $ip <= $to);
                break;
            case 'mask':
        	    $mask = $op['mask'];
        	    $net = $op['network'];
                return ($ip & $mask) == ($net & $mask);
            case 'all':
                return true;
            break;
        }
    }
}