<?php

namespace Sentiweb\Symfony\Auth\Provider;

class BasicAuth extends AbstractAuth {
    
    protected $password;
    
    protected $realm;
    
    protected $username;
        
    public function __construct($conf) {
        $this->realm = $conf['realm'];
        $this->username = isset($conf['username']) ? $conf['username'] : false;
        $this->password= $conf['password'];
        if(!$this->password) {
            throw new \Exception('Empty password in configuration');
        }
    }
    
    function requestAuth() {
        header('WWW-Authenticate: Basic realm="'.$this->realm.'"');
        header('HTTP/1.0 401 Unauthorized');
        $this->log('request basic auth');
        die();
    }
    
    function check() {
        if( !(isset($_SERVER['PHP_AUTH_USER']) and isset($_SERVER['PHP_AUTH_PW'])) ) {
            $this->log('PHP AUTH headers not found');
            $this->requestAuth();
        }
        $username = $_SERVER['PHP_AUTH_USER'];
        $pwd = $_SERVER['PHP_AUTH_PW'];
        if(!$pwd) {
            $this->requestAuth();
        }
        // Check username if defined
        // This allow to check only password 
        if($this->username) {
            if($username != $this->username) {
                $this->log('username doesnt match');
                $this->requestAuth();
            }
        }
        if($pwd != $this->password) {
            $this->log('password doesnt match');
            $this->requestAuth();
        }
        $this->log('basic auth ok');
        return true;
    }
}