<?php
namespace Sentiweb\Symfony\Auth\Provider;

use Psr\Log\LoggerInterface;
/**
 * An authentication method
 * Simple Auth for page-based auth or dev
 * @author ClementTurbelin
 *
 */
abstract class AbstractAuth {
    
    /**
     * Logger
     * @var LoggerInterface
     */
    private $logger;
    
    protected $debug = false;
    
    public function setDebug($debug) {
        $this->debug = $debug;
    }
    
    public function setLogger(LoggerInterface $logger) {
        $this->logger = $logger;
    }
    
    public function log($msg) {
        if($this->logger) {
            if($this->debug) {
                $this->logger->debug($msg);
            } else {
                //$this->logger->info($msg);
            }
        }
    }
    
    abstract public function check();
}