<?php
namespace Sentiweb\Symfony\Auth;


/**
 * This class is intented to provide an authentication for app_dev.php
 * 
 * Just add in app_dev.php the line, after the bootstrap loader line
 * 
 * $auth = new AppDevAuth();
 * 
 * Configuration should be placed in app/config/dev.php
 * returning an array of config
 * 
 * array(
 *   // Placeholder for global options
 *   'localhost'=>boolean,
 *   'auth'=>array( // Auth method config
       'basic'=>array()
 *     'ip'=>array(),
 *   )
 * 
 * @author ClementTurbelin
 *
 */
class AppDevAuth {
    
    protected $conf;
    
    public function __construct() {
        $fn = '../app/config/dev.php';
        if( file_exists($fn) ) {
            $this->conf = require $fn;
        }
        $this->check();
    }
    
    protected function stop() {
        header('HTTP/1.0 403 Forbidden');
        exit('You are not allowed to access this file.');
    }
    
    public function getAuth($method, $conf) {
    	$method = strtolower($method);
    	switch($method) {
    		case 'basic': 'Basic'; break;
    		case 'ip': 'IP'; break;
    		default:
    			throw new \Exception('Unknown auth method');
    	}
    	$class = __NAMESPACE__.'\\Provider\\'.$method.'Auth';
    	return new $class($conf);
    }
    
    
    public function check() {
        $accept_localhost = isset($this->conf['localhost']) ? (bool)$this->conf['localhost'] : true;
    	if($accept_localhost) {
	    	if( in_array(@$_SERVER['REMOTE_ADDR'], array('127.0.0.1', '::1'))) {
	            return true;
	        }
    	}
	    $auths = isset($this->conf['auth']) && is_array($this->conf['auth']) ? $this->conf['auth'] : array(); 
	    foreach($auths as $method=>$conf) {
	    	$auth = $this->getAuth($method, $conf);
	    	if($auth->check()) {
	    		return true;
	    	}
	    }
        $this->stop();
    }
    
}

